% Model of a nonisothermal batch reactor - Alkylation

% Function file

% For more information, see:

% A. De Visscher 
% Lecture Notes in Chemical Engineering Kinetics and Chemical Reactor Design
% Createspace (2013) 

% (C) Alex De Visscher (2013)

% ---------------------------

function dcdt = f(t,c,cC40,ciC40,ciC80,A,EA,B,H,V,m,Ac,U,Tc,ws,DH0,CpiC4,CpC4,CpiC8,DCp)

dcdt = zeros(2,1);     % Allocate space for the right-hand sides of the DEs

cC4 = c(1);                  % Butene concentration
T = c(2);                    % Temperature
ciC4 = ciC40 - cC40 + cC4;   % Isobutane concentration (from stoichiometry)
ciC8 = ciC80 + cC40 - cC4;   % Isooctane concentration (from stoichiometry)

R = 8.314472;
k1 = A*exp(-EA/(R*T));       % Rate constants
K = B*exp(H/(R*T));
r = k1*cC4/(1 + K*cC4/ciC4); % Reaction rate

DH = DH0 + DCp*(T - 298.15);
q = U*Ac*(Tc - T);
Cpsum = V*(cC4*CpiC4 + ciC4*CpiC4 + ciC8*CpiC8);

dcdt(1) = -m*r/V;            % Differential equation for concentration
dcdt(2) = (-m*r*DH + ws + q)/Cpsum;
